/****************************************************************************/
//
//  GangPro-ARM Programmer - Multi-API-DLL software
//  Author: Elprotronic Inc.
//  Elprotronic Inc. 2003-2026
//  
/****************************************************************************/
// THIS PROGRAM IS PROVIDED "AS IS". ELPROTRONIC INC. MAKES NO WARRANTIES OR
// REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
// INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
// FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
// COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
// ELPROTRONIC INC. DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
// POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
// INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
// YOUR USE OF THE PROGRAM.
//
// IN NO EVENT SHALL ELPROTRONIC INC. BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
// CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
// THEORY OF LIABILITY AND WHETHER OR NOT ELPROTRONIC INC. HAS BEEN ADVISED 
// OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
// OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
// EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
// REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
// OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
// USE OR INTERRUPTION OF BUSINESS. 
//
// Unless otherwise stated, the Program written and copyrighted 
// by Elprotronic Inc. is distributed as "freeware".  You may, 
// only under Elprotronic's Inc. copyright in the Program, use and modify the 
// Program without any charge or restriction.  You may 
// distribute to third parties, provided that you transfer a 
// copy of this license to the third party and the third party 
// agrees to these terms by its first use of the Program. You 
// must reproduce the copyright notice and any other legend of 
// ownership on each copy or partial copy, of the Program.
//
// You acknowledge and agree that the Program contains 
// copyrighted material, trade secrets and other Elprotronic Inc. proprietary 
// information and is protected by copyright laws, 
// international copyright treaties, and trade secret laws, as 
// well as other intellectual property laws.  To protect Elprotronic's Inc. 
// rights in the Program, you agree not to decompile, reverse 
// engineer, disassemble or otherwise translate any object code 
// versions of the Program to a human-readable form.  You agree 
// that in no event will you alter, remove or destroy any 
// copyright notice included in the Program.  Elprotronic Inc. reserves all 
// rights not specifically granted under this license. Except 
// as specifically provided herein, nothing in this agreement 
// shall be construed as conferring by implication, estoppel, 
// or otherwise, upon you, any license or other right under any 
// Elprotronic Inc. patents, copyrights or trade secrets.
//
/****************************************************************************/

#ifndef GANGPRO_DLL_H
#define GANGPRO_DLL_H

#ifndef __GNUC__
#define MSWIN_API		//comment out for Borland, DOS applications  etc if the CString is not supported

#ifdef  MSPPRG_DLL
   #define MSPPRG_API __declspec(dllexport)
#else
   #define MSPPRG_API __declspec(dllimport)
#endif

#ifdef  MSWIN_API
  #define		CSTRING_EN
#endif

#else //__GNUC__
#define MSPPRG_API __attribute__ ((visibility("default")))
#define __stdcall  
#endif

#include <stdint.h>
typedef		int32_t         INT_X;
typedef     uint16_t		UINT16;
typedef     uint32_t		UINT32;
typedef		uint8_t			BYTE;
typedef		BYTE*			BYTE_PTR;
typedef		void *			VOID_PTR;
typedef 	uint64_t		ULONG64;

#define		TARGET_1_MASK	0x01
#define		TARGET_2_MASK	0x02
#define		TARGET_3_MASK	0x04
#define		TARGET_4_MASK	0x08
#define		TARGET_5_MASK	0x10
#define		TARGET_6_MASK	0x20
#define		TARGET_7_MASK	0x40
#define		TARGET_8_MASK	0x80
#define		GANG_MASK		0xFF	//all targets
#define		GANG_SIZE		8

#define		REPORT_MESSAGE_MAX_SIZE		20000
#define		MAX_USB_DEV_NUMBER			64
#define		MAX_FPA_INDEX				64
#define		ALL_ACTIVE_FPA				0
#define		FPA_UNMATCHED_RESULTS		-1
#define		FPA_INVALID_NO				-2
#define		PRG_ADAPTER_NOT_DETECTED	4	

#define		INVALID_CODE_FILE		0x08
#define		CODE_OUT_OF_FLASH		0x40
#define		CODE_OVERWRITTEN		0x80

#include "comm_definitions.h"

//====================================================================
//         Flash definition
//====================================================================

#define	FLASH_PASSW_LEN				8
#define	NO_OF_CSM_PASSWORDS			4

#define	CSM_DEFAULT_INDEX			0
#define	CSM_CODE_FILE_INDEX			1
#define	CSM_PASSWORD_FILE_INDEX		2
#define	CSM_DEFINED_INDEX			3
#define	CSM_MAX_INDEX				CSM_DEFINED_INDEX

#define	RESET_10MS_INDEX            0
#define	RESET_50MS_INDEX			0	//not valid
#define	RESET_100MS_INDEX			1
#define	RESET_200MS_INDEX			2
#define	RESET_500MS_INDEX			3
#define	RESET_CUSTOM_INDEX			4
#define RESET_SOFT_INDEX			5
#define	RESET_MAX_INDEX				RESET_SOFT_INDEX

#define	APPLICATION_KEEP_RESET		0
#define	APPLICATION_TOGGLE_RESET	1
#define	APPLICATION_NOT_RESET		2
#define	APPLICATION_JTAG_RESET		3
#define	APPLICATION_TOGGLE_VCC		4
#define	APPLICATION_RESET_MAX_INDEX	APPLICATION_TOGGLE_VCC

#define	VERIFY_NONE_INDEX			0
#define	VERIFY_STD_INDEX			1
#define	VERIFY_FAST_INDEX			2
#define	VERIFY_MAX_INDEX			VERIFY_FAST_INDEX

#define	DEFAULT_JTAG_3ST			0
#define	DEFAULT_JTAG_HI				1
#define	DEFAULT_JTAG_LO				2
#define	MAX_DEFAULT_JTAG			DEFAULT_JTAG_LO

#define DEFAULT_RESET_LO		0
#define DEFAULT_RESET_HI		1
#define DEFAULT_RESET_3ST		2



extern "C"
{
//Functions are described in more detail in DLL user guide, GP-ARM-API-DLL-User-Guide.pdf
//When selecting all FPAs, F_Set_FPA_index(0), any API-DLL function can also return:
//	FPA_UNMATCHED_RESULTS : Result of operation inconsistent across all selected FPAs, call F_LastStatus on single FPA
//  FPA_INVALID_NO : FPA not opened with F_OpenInstancesAndFPAs or index out of range
//This does not apply to Multi API-DLL calls.

//Call structure (Figure 1.2 GP-ARM-API-DLL-User-Guide.pdf):
//Multi API-DLL (GangProARM-FPAsel.dll) (Multi-API DLL Functions)
//-(1) : API-DLL (GangProARM-FPA1.dll)	(Generic, Data Buffer, Encapsulated, Sequential Functions)
//-(2) : API-DLL (GangProARM-FPA2.dll)	(Generic, Data Buffer, Encapsulated, Sequential Functions)
//-(3) : API-DLL (GangProARM-FPA3.dll)	(Generic, Data Buffer, Encapsulated, Sequential Functions)
//-(4) : API-DLL (GangProARM-FPA4.dll)	(Generic, Data Buffer, Encapsulated, Sequential Functions)
//-(5) : API-DLL (GangProARM-FPA5.dll)	(Generic, Data Buffer, Encapsulated, Sequential Functions)
//......
//-(64): API-DLL (GangProARM-FPA64.dll)	(Generic, Data Buffer, Encapsulated, Sequential Functions)
//F_Set_FPA_index(0) to send commands to all API-DLLs

	// ------------------  Multi-API DLL Functions ----------------------------
	/*
	These functions operate on meta-data within the Multi API-DLL and help manage the underlying API-DLL instances. 
	These functions do not directly program target devices. Use these functions to initialize the desired number of FPAs, 
	selected all or one FPA(s), read FPA serial numbers, or clean-up resources used by Elprotronic�s DLLs. Once the 
	desired FPAs have been successfully opened, use Generic Functions to initialize the FPAs, and con?gure them for 
	the target device(s) being programmed.
	*/	

	INT_X  MSPPRG_API	F_OpenInstancesAndFPAs( char * FileName );
	//  number of instances and FPA's assigment - vs FPA's Serial Number.
	//  FPAs configuration specified in the file "FileName" - full access path
	//  return   number of opened instances
	//
	//  Syntax of the FPAs configuration specified
	//  FPA-x   Serial Number
	//  where  FPA-x can be  FPA-1, FPA-2, FPA-3 .... 
	//   e.g  (without semicolon  - comment)
	//  FPA-1   20050116
	//  FPA-3   20050199
	//  FPA-5   20050198
	//  return: number of opened instances

	INT_X  MSPPRG_API	F_CloseInstances( void );
	// Free API-DLLs from initialized FPAs
	// return:  1 - TRUE

	INT_X  MSPPRG_API	F_Set_FPA_index( BYTE fpa );
	// select fpa index. Set fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	// return:  1 - TRUE or Error number

	BYTE   MSPPRG_API	F_Get_FPA_index( void );
	// return:  current fpa index

	INT_X  MSPPRG_API	F_Check_FPA_index( void );
	// similar to F_Get_FPA_index(), but when the fpa is invalid then returns FPA_INVALID_NO
	// return:  current fpa index if selected FPA has been opened with F_OpenInstancesAndFPAs

	void  MSPPRG_API	F_Enable_FPA_index( BYTE fpa );
	// enable selected fpa index (default is enabled). Will be included in 
	// operations when fpa_index = ALL_ACTIVE_FPA, or if this fpa is selected
	// FPA - index no (1..MAX_FPA_INDEX)	

	void  MSPPRG_API	F_Disable_FPA_index( BYTE fpa );
	// disable selected fpa index.  Will be ignored for all operations
	// FPA - index no (1..MAX_FPA_INDEX)

	INT_X  MSPPRG_API	F_LastStatus( BYTE fpa );
	// Use this function to get single-fpa results when other functions return FPA_UNMATCHED_RESULTS
	// return last status taken from the selected fpa (fpa = 1..MAX_FPA_INDEX)	

	INT_X  MSPPRG_API	F_Multi_DLLTypeVer( void );
	// return	 Type + Version	
	//           Type	0x6000 - Multi-FPA FlashPro430
	//					0x7000 - Multi-FPA GangPro430
	//					0x8000 - Multi-FPA FlashPro-CC
	//					0x9000 - Multi-FPA GangPro-CC
	//					0xC000 - Multi-FPA FlashPro2000
	//					0xD000 - Multi-FPA GangPro2000
	//				   0x10000 - Multi-FPA FlashPro-ARM
	//				   0x11000 - Multi-FPA GangPro-ARM
	//				   0x17000 - Multi-FPA FlashPro-M
	//				   0x18000 - Multi-FPA GangPro-M
	//			 Version = 0x0FFF & version

	INT_X  MSPPRG_API	F_Get_FPA_SN( BYTE );
	//  return: 0 - Adapter not detected	
	//         >0 - Active Adapter's Serial Number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX

	typedef struct
	{
		UINT32  active;
		UINT32  SN;
		UINT32  CommType;
		UINT32  HW_ID;
		UINT32  HW_rev;
		std::string  text;
		std::string  access_text;
	} ALL_FPA_LIST;

	//i.e.: 
	//ALL_FPA_LIST FPA_List[MAX_USB_DEV_NUMBER];
	//F_Get_FPA_List(FPA_List);
	INT_X  MSPPRG_API	F_Get_FPA_List( ALL_FPA_LIST * FPA_List );	// FPA_List -> size MAX_USB_DEV_NUMBER

	INT_X  MSPPRG_API	F_Get_FPA_Label( BYTE fpa, BYTE * label );
	// fpa = 1....MAX_FPA_INDEX
	
	#define ADAPTER_HARDWARE_PN_SIZE		21	
	#define ADAPTER_DESCRIPTION_SIZE		32
	#define FPA_LABEL_SIZE					((ADAPTER_HARDWARE_PN_SIZE + ADAPTER_DESCRIPTION_SIZE)*sizeof(char) + 12*sizeof(BYTE) + sizeof(long))
	//union FPA_LABEL
	//{
	//	BYTE	bytes[ FPA_LABEL_SIZE ];
	//	struct
	//	{
	//		long  SN;
	//		BYTE  hardware_ID;
	//		BYTE  hardware_SubID;
	//		BYTE  full_access;
	//		BYTE  Interface_Type;
	//		BYTE  Valid_access_key;
	//		BYTE  spare3;
	//		BYTE  spare4;
	//		BYTE  spare5;
	//		BYTE  spare6;
	//		BYTE  spare7;
	//		BYTE  spare8;
	//		BYTE  spare9;
	//		char  adapter_hardware_PN[ ADAPTER_HARDWARE_PN_SIZE ];
	//		char  adapter_description[ ADAPTER_DESCRIPTION_SIZE ];
	//	}x;
	//};

#ifndef XS_ADC_H
#define XS_ADC_H
#define	XS_ADC_NUM_MEMBERS 15
	union XS_ADC
	{
		double	members[XS_ADC_NUM_MEMBERS];
		struct
		{
			double ExtVcc;				//actual external Vcc value in V
			double Vcc;					//actual Vcc from programmer value in V
			double Vpp;					//actual Vpp for fuse blown from programmer value in V
			double ExtVccMin;			//external Vcc value in V - min value from the last read up to now
			double ExtVccMax;			//external Vcc value in V - max value from the last read up to now
			double VccMin;				//Vcc value in V - min value from the last read up to now
			double VccMax;				//Vcc value in V - max value from the last read up to now
			double Icc_mA;				//Icc value in mA - current value
			double Icc_mA_av4;			//Icc value in mA - average for last 4 read (interval ~ 10ms)
			double Icc_mA_av16;			//Icc value in mA - average for last 16 read (interval ~ 10ms)
			double Icc_mA_min;			//Icc value in mA - min value from the last read up to now
			double Icc_mA_max;			//Icc value in mA - max value from the last read up to now
			double Temperature;			//Temperature inside XStream in C deg
			double Icc_mA_av64;			//Icc value in mA - average for alpha 1/64
			double Icc_mA_av;			//Icc value in mA - average for defined alpha 1/N
		} data;
	};
#endif
	INT_X	MSPPRG_API F_Get_Power_Results(double *xs_adc);

#ifndef TRACE_DATA_H
#define TRACE_DATA_H
#define	TRACE_DATA_MEMBERS 4
	//Configuration value "Graph_MeasureMode_index" specifies the mode
	union TRACE_DATA
	{
		double	members[TRACE_DATA_MEMBERS]; //for any mode, up to 4 pieces of data displayed on graph
											 //Mode 0. Disabled - no data
		struct
		{//Mode 1. Output nominal voltage and current (Vcc, Icc) 
			double Vcc;
			double Icc;
			double blank1;
			double blank2;
		} mode1;
		struct
		{//Mode 2. Output nom.voltage and current, external voltage, and prog.voltage(MSP430) (Vcc, Icc, Vext, Vpp)
			double Vcc;
			double Vext;
			double Vpp;
			double Icc;
		} mode2;
		struct
		{//Mode 3. Nominal output and external voltage (Vcc, Vext)
			double Vcc;
			double Vext;
			double blank1;
			double blank2;
		} mode3;
		struct
		{//Mode 4. Output nominal and minimum voltage (Vcc, Vccmin)
			double Vcc;
			double Vccmin;
			double blank1;
			double blank2;
		} mode4;
		struct
		{//Mode 5. External nominal and min. voltage (Vext, Vextmin)
			double Vext;
			double Vextmin;
			double blank1;
			double blank2;
		} mode5;
		struct
		{//Mode 6. Output nominal and min. voltage, and output and max. current (Vcc, Vccmin, Icc, Iccmax)
			double Vcc;
			double Vccmin;
			double Icc;
			double Iccmax;
		} mode6;
		struct
		{//Mode 7. Output nom. and min. volt., and out. avg. (alpha=defined) and max. current (Vcc, Vccmin, Iccavg, Iccmax)
			double Vcc;
			double Vccmin;
			double Iccavg;
			double Iccmax;
		} mode7;
		struct
		{//Mode 8. Output nom. and min. volt., and out. avg. (FIR alpha=1/16) and max. current (Vcc, Vccmin, Iccavg, Iccmax)
			double Vcc;
			double Vccmin;
			double Iccavg;
			double Iccmax;
		} mode8;
		struct
		{//Mode 9. Output nom. and min. volt., and out. avg. (alpha=1/64) and max. current (Vcc, Vccmin, Iccavg, Iccmax)
			double Vcc;
			double Vccmin;
			double Iccavg;
			double Iccmax;
		} mode9;
	};
#endif
	INT_X	MSPPRG_API F_Get_Power_Results_Start();//Start gathering samples in history buffer
	INT_X	MSPPRG_API F_Get_Power_Results_Stop();//Stop gathering samples in history buffer
	MSPPRG_API std::vector<TRACE_DATA> * F_Get_Power_Results_History();//Retrieve samples from history buffer

	INT_X	MSPPRG_API F_Get_Last_Power_Results_data(double *xs_adc);
			//provide results taken from the last power measuremet (used function F_Get_Power_Results(double *xs_adc)) 

	//XStreamPro-Iso only
	INT_X	MSPPRG_API F_XS_Update_HW_State(BYTE mode, INT_X data);
#ifndef __IO_SETTINGS__
#define __IO_SETTINGS__
	// mode
	#define		MODE_XS_IO_SET_FLAGS		0x12
	#define		MODE_XS_IO_CLR_FLAGS		0x13
	// data
	#define         IO_PULLUP_EN			1
	#define         FORCE_ICC_LOW_SENSITIVITY	2
	#define         FORCE_ICC_HI_SENSITIVITY	4
#endif
	//example - disable I/O 1M pull-ups in 3-state 
	//		F_Update_HW_State( MODE_XS_IO_CLR_FLAGS, IO_PULLUP_EN );
	//example - Force current HI sensitivity range
	//		F_Update_HW_State( MODE_XS_IO_SET_FLAGS, FORCE_ICC_HI_SENSITIVITY );
	//		F_Update_HW_State( MODE_XS_IO_CLR_FLAGS, FORCE_ICC_LOW_SENSITIVITY );

	INT_X  MSPPRG_API	F_XS_Clr_ADC_av_history();
	// Deletes current measurement history, useful to get rid of long running averages.

	INT_X  MSPPRG_API   F_XS_Current_zeroing( int state, char *txt );
	// Example for calling function above
	// char txt[200];
	//  	for( state = 0; state < 100; state++)	//mandatory state from 0 to 100
	//      {  
	//	      F_XS_Current_zeroing( state, txt );
	//      } 
	//  - state can be used also as the progress bar 0..100
	//  txt - comment related to currently executing part of zeroing procedure - the same as it is displayed in GUI

	INT_X  MSPPRG_API	F_GetProgressBar( BYTE fpa );
	//Only for encapsulated functions
	//General function that only reads current value of progress bar between 0 and 100.  Thread-safe
	//One thread can call F_AutoProgram (for example) and another thread can monitor progress by calling
	//F_GetProgressBar
  
	INT_X  MSPPRG_API	F_GetLastOpCode( BYTE fpa );
	#define PROG_OPCODE_VERIFY_ACCESS				1
	#define	PROG_OPCODE_FLASH_ERASE					2
	#define	PROG_OPCODE_FLASH_BLANK_CHECK			3
	#define	PROG_OPCODE_FLASH_SELECTED_BLANK_CHECK	4
	#define PROG_OPCODE_FLASH_WRITE					5
	#define	PROG_OPCODE_FLASH_VERIFY				6
	#define	PROG_OPCODE_FLASH_READ					7
	#define	PROG_OPCODE_LOCK_MCU					8
	#define	PROG_OPCODE_UNLOCK_MCU					9
	#define	PROG_OPCODE_START_APP					10
	//Only for encapsulated functions
	//General function that reads code for last operation performed. Useful for providing comments for ProgressBar and 
	//when AutoProgram fails half way to indicate which sub-operation failed. Thread-safe
	//
	//One thread can call F_AutoProgram (for example) and another thread can monitor progress of sub-operations
	//by calling F_GetProgressBar and F_GetLastOpCode. F_AutoProgram will usually go through all of these sub-operations 
	//in seqeuence, each progressing from 0 to 100. If the blank-check sub-operation fails in F_AutoProgram, then this 
	//function will keep returning PROG_OPCODE_FLASH_BLANK_CHECK after F_AutoProgram returns FAIL.

	INT_X  MSPPRG_API	F_CancelAction( BYTE fpa );
	//Only for encapsulated functions
	//Function that will attempt to cancel all the running encapsulated functions, like the GUI Cancel button.  Thread-safe
	//One thread can call F_AutoProgram (for example) and another thread can call F_CancelAction to stop the first.
	//A reinitialization is recommended using F_OpenInstancesAndFPAs after calling this function.

	
	INT_X	MSPPRG_API	F_Trace_File( char *FileName, bool append = false );
	// set custom FileName for trace (used with Trace_ON).  Set append flag true to keep previous contents.
	// return:	0 - FALSE (failed to open file)
	//			1 - TRUE (opened file successfully)

	void   MSPPRG_API   F_Trace_Comment(char *comment);
	// append a custom comment to current trace file

	void	MSPPRG_API	F_Trace_ON( void );
	// enable trace: save names and parameters of functions called to DLLtrace.txt in current working directory

	void	MSPPRG_API	F_Trace_OFF( void );
	// disable trace
	
	// ------------------------------------------------------------------------

	// ------------------------  Generic Functions ----------------------------
	/*
	Generic functions read and write the API-DLL�s con?guration, access status messages and can instruct the FPA 
	to power or reset the target device. The functions described in this section require that each FPA already be 
	opened using F OpenInstancesAndFPAs.
	*/

	INT_X  MSPPRG_API	F_Initialization( void );
	// return:   0 - FALSE
	//           1 - TRUE
	//			 4 - Programmer adapter is not detected
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA		
	
	INT_X  MSPPRG_API	F_Use_Config_INI(BYTE use);
	//Configure F_Initialization to use (default) or skip config.ini file
	//	input 1 to use config.ini, input 0 to skip
	//when skipping config.ini it is necessary to use ConfigFileLoad or Set_Config_Value_By_Name functions to
	//configure the adapter.
	//	return		0 - FALSE (state unchanged)
	//				1 - TRUE (state changed to input parameter)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA		

	//======================================================================================================//
	//Programmatically print and set configuration values from *.cfg file provided to F_ConfigFileLoad
	MSPPRG_API char *	F_Get_Config_Name_List(INT_X index);
	//Iterate over configuration names, starting from <index> 0.  Increase <index> until return is "\0".
	//Will return char array with name of config parameter or "\0" once <index> is too high.

	unsigned int MSPPRG_API F_Get_Config_Value_By_Name(char *name, INT_X type);
	//Use F_Get_Config_Name_List to get configuration parameter names, then use them as input 
	//to this function.  Select type to determine action:
#define		CONFSEL_VALIDATE	0 //- returns TRUE if <name> was found in config list
#define		CONFSEL_VALUE		1 //- returns current value of config parameter
#define		CONFSEL_MIN			2 //- returns minimum value that this config parameter can have
#define		CONFSEL_MAX			3 //- returns maximum value that this config parameter can have
#define		CONFSEL_DEFAULT		4 //- returns default value for this parameter if not set by user/file
	//returns FALSE if invalid <name> given

	INT_X	MSPPRG_API	F_Set_Config_Value_By_Name(char *name, unsigned int newValue);
	//Use F_Get_Config_Name_List to get configuration parameter names, then use them as input 
	//to this function.  Use F_Get_Config_Value_By_Name to get proper ranges for config values.
	//
	//Set new value for configuration parameter identified by <name>.
	//If the config parameter is out of range, it will be reset to default value.
	//Returns TRUE if <name> was valid, or FALSE if <name> was invalid
	//Run F_Get_Config_Value_By_Name(<name>, CONFSEL_VALUE) after to verify change of configuration parameter.

	//======================================================================================================//
	//Get setup config string name list for string parameters
	MSPPRG_API char* F_Get_String_Config_Name_List(int index);

	//Get current setup configuration for string parameters - could be read from file, or read from software configuration
	MSPPRG_API char * F_Get_String_Config_Value_By_Name(char *name, int type);
	//Use F_Get_String_Config_Name_List to get configuration parameter names, then use them as input 
	//to this function.  Select type to determine action:
	//#define		CONFSEL_VALIDATE	0 //- returns parameter name if <name> was found in config list
	//#define		CONFSEL_VALUE		1 //- returns current value of config parameter
	//#define		CONFSEL_DEFAULT		4 //- returns default value for this parameter if not set by user/file
	//returns FALSE if invalid <name> given

	//Set setup configuration by software
	int MSPPRG_API F_Set_String_Config_Value_By_Name(char *name, char *newValue);
	//======================================================================================================//
	
	INT_X  MSPPRG_API	F_Get_Device_Info( INT_X index );
	//where index
	#define	DEVICE_NAME						0
	#define	DEVICE_NAME_SIZE				20
	#define	DEVICE_FAMILY_INDEX				20
	#define	DEVICE_GROUP_INDEX				21
	#define	DEVICE_NAME_INDEX				22
	#define	DEVICE_GROUP					23
	#define	DEVICE_FLASH_START_ADDR			24
	#define	DEVICE_FLASH_END_ADDR			25
	#define	DEVICE_OTP_START_ADDR			26
	#define	DEVICE_OTP_END_ADDR				27
	#define	DEVICE_RAM_START_ADDR			28
	#define	DEVICE_RAM_END_ADDR				29
	#define DEVICE_VENDOR_INDEX				30
	#define	DEVICE_EEPROM_START_ADDR		31
	#define	DEVICE_EEPROM_END_ADDR			32
	#define	DEVICE_COMM_INTERFACES			33
	#define DEVICE_EXTFLASH_START_ADDR		34
	#define DEVICE_EXTFLASH_END_ADDR		35
	//  fpa = 1....MAX_FPA_INDEX
	//  return  -1 if invalid data
	//   or	
	//	  index - 0 to 19  -> device name - char by char starting from index->0 => T eg.  TMS320F2808   
	// 	     index 0 -> 'L'
	// 	     index 1 -> 'M'
	// 	     index 2 -> '4'   LM4F110B2QR
	// 	     index 3 -> 'F'
	// 	     index 4 -> '1'
	// 	     index 5 -> '1'
	// 	     index 6 -> '0'
	// 	     index 7 -> 'B'
	// 	     index 8 -> '2'
	// 	     index 9 -> 'Q'
	// 	     index 10 -> 'R'
	// 	     index 11 -> 0x0000  -> end of string
	//	  index 20 -> Family Index (subset of MCU vendor, index 30)
	//	  index 21 -> Group Index (subset of MCU family, index 20)
	//	  index 22 -> Name Index (subset of MCU group, index 21)
	//    index 23 -> Group (obsolete)
	// 	  index 24 -> Flash Start Address  eg 0x00000
	// 	  index 25 -> Flash End  Address   eg 0x1FFFF
	// 	  index 26 -> OTP Start Address    eg 0x400FE1E0
	// 	  index 27 -> OTP End  Address     eg 0x400FE1EF
	// 	  index 28 -> RAM Start Address    eg 0x20000000
	// 	  index 29 -> RAM End Address      eg 0x2000FFFF
	// 	  index 30 -> Vendor Index (superset of all supported MCUs, i.e. company name)
	// 	  index 31 -> EEPROM Start Address  eg 0x08080000
	// 	  index 32 -> EEPROM End Address    eg 0x080803FF
	// 	  index 33 -> MCU communication interfaces eg 0x30 ( COMM_JTAG | COMM_SWD )
	//	  index 34 -> External Flash Start Address  eg 0x10000000
	//	  index 35 -> External Flash End Address    eg 0x1001FFFF

	INT_X  MSPPRG_API	F_Set_MCU_Name( char * MCU_name );
	//  return:  -1 - not found,  X - MCU index if MCU_name was found
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	MSPPRG_API	void* F_Search_MCU_Name( char *MCU_name_regex, char *Vendor_filter, int mode, int flags );
	// MCU_name_regex - regular expression
	/*
	*   '.'        Dot, matches any character
	*   '^'        Start anchor, matches beginning of string
	*   '$'        End anchor, matches end of string
	*   '*'        Asterisk, match zero or more (greedy)
	*   '+'        Plus, match one or more (greedy)
	*   '?'        Question, match zero or one (non-greedy)
	*   '[abc]'    Character class, match if one of {'a', 'b', 'c'}
	*   '[a-zA-Z]' Character ranges, the character set of the ranges { a-z | A-Z }
	*   '\s'       Whitespace, \t \f \r \n \v and spaces
	*   '\S'       Non-whitespace
	*   '\w'       Alphanumeric, [a-zA-Z0-9_]
	*   '\W'       Non-alphanumeric
	*   '\d'       Digits, [0-9]
	*   '\D'       Non-digits
	*/
	//Vendor_filter - Limit to one vendor only, to speed up search function esp in mode with more than first match result.
	/*
	* NULL all enabled lists on this adapter
	* "Active-Semi"
	* "Analog Devices"
	* "Cypress"
	* "Microchip/Atmel"
	* "Marvell Tech."
	* "Maxim Integrated"
	* "Nordic Semiconductor"
	* "NXP/Freescale"
	* "Renesas"
	* "Silergy"
	* "Silicon Labs"
	* "ST Microelectronics"
	* "Texas Instruments-ARM"
	* "Texas Instruments-Chipcon"
	*/
	// mode: 
	//  mode 0, returns the first match to MCU_name_regex, a type (char *). Library will alloc and free this memory by itself, do not modify contents
	//  mode 1, returns the pointer to a list of matches to MCU_name_regex, a type (char **). Library will alloc and free this memory by itself, do not modify contents
	// flags: 
	//	for mode 0, not used
	//	for mode 1, max number of results to return, unlimited if 0
	//  return:  NULL if no match, 
	//  more regex modes TBA...
	//  You can use a valid MCU_name output of this function to call F_Set_MCU_Name
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX, 0 will return NULL	

	void  MSPPRG_API	F_Reset_Config();
	//reset all configuration values to default for selected MCU.

/******** Use these two functions together to get all supported MCU names *********/
	//Detailed example in DLL functions chapter, section F_Set_MCU_Family_Group (GP-ARM-API-DLL-User-Guide.pdf)
	MSPPRG_API	char *  F_Get_MCU_Name_list( INT_X type, INT_X index );
	#define		MCU_VENDOR_LIST		0
	#define		MCU_FAMILY_LIST		1
	#define		MCU_GROUP_LIST		2
	#define		MCU_NAME_LIST		3
	// return: valid name if correct parameters provided, "" otherwise
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX

	INT_X  MSPPRG_API	F_Set_MCU_Family_Group( INT_X type, INT_X index );
	//#define		MCU_VENDOR_LIST		0
	//#define		MCU_FAMILY_LIST		1
	//#define		MCU_GROUP_LIST		2
	//#define		MCU_NAME_LIST		3
	// return: 0 - index parameter out of range
	//		   1 - index parameter set correctly	
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX
/******** Use the above two functions to get all supported MCU names **************/

	void	 MSPPRG_API	F_ReportMessage( char * text );
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX

	MSPPRG_API	char* F_Report_Message( void );
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX

	BYTE   MSPPRG_API	F_GetReportMessageChar( INT_X index );
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX

	INT_X  MSPPRG_API	F_DLLTypeVer( void );
	// return	 Type + Version	
	//           Type   0x1000 - Single FlashPro430 - Parallel Port type  
	//					0x2000 - Single FlashPro430 - USB type  
	//					0x3000 - Single GangPro430  - USB type  
	//					0x4000 - Single FlashPro-CC - USB type  
	//					0x5000 - Single GangPro-CC  - USB type  
	//					0xA000 - Single FlashPro2000- USB type  
	//					0xB000 - Single GangPro2000 - USB type  
	//					0xE000 - Single FlashPro-ARM - USB type  
	//					0xF000 - Single GangPro-ARM - USB type  
	//			 Version = 0x0FFF & version
	// extra message in the report buffer 		

	INT_X  MSPPRG_API	F_ConfigFileLoad( char * filename );
	// filename - full name including path, file name and extantion
	//  return:  0 - FALSE,  1 - TRUE or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_LoadFromImage(char * fullPath, char *password);
	// fullPath - fullPath including path, file name and extension of *.eimg
	// password - "" or password (up to 16 chars) if image is password locked
	//  return:  0 - FALSE,  1 - TRUE or Error number

	INT_X	 MSPPRG_API	F_Power_Target( INT_X OnOff );
	//  return:  0 - FALSE,  1 - TRUE
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	
	INT_X  MSPPRG_API	F_Reset_Target( void );
	//  return:  0 - FALSE,  1 - TRUE
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Get_Targets_Vcc( void );
	//GangPro-ARM has a shared Vcc line for all target MCUs
	//  return   -1 - no communication with FPA
	//	return   0 and up - Vcc in milivolts
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X	 MSPPRG_API	F_Set_fpa_io_state( BYTE jtag, BYTE reset, BYTE VccOn );
	//  jtag ->  TMS, TCK, TDI (output from FPA)
	//          DEFAULT_JTAG_3ST   ( 0 )
	//			DEFAULT_JTAG_HI	   ( 1 )
	//			DEFAULT_JTAG_LO    ( 2 )
	// reset -> DEFAULT_RESET_LO    ( 0 )
	//			DEFAULT_RESET_HI	( 1 )
	//			DEFAULT_RESET_3ST   ( 2 )
	// VccOn ->  0  -> output Vcc from FPA - OFF
	//			 1  -> output Vcc from FPA - ON (level 2.2V to 3.6V set in CFG_VCCINDEX )
	//  return: 0 - FALSE,  1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Get_Sector_Size( INT_X address );
	//returns <sector size> for sector that includes given address
	//returns 0 for incorrect addresses (address that does not fit within any sector)
	//  return: 0 - address out of range, X - actual sector size
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	// ------------------------------------------------------------------------

	// ------------------------  Data Buffer Functions ----------------------------
	/*
	Use the functions in this section to specify what code should be written by each FPA to their target device. 
	All data buffers are enumerated and explained in detail in the user guide (GP-ARM-API-DLL-User-Guide.pdf)
	*/

	INT_X  MSPPRG_API	F_ReadCodeFile( char * FileName );	
	// Input is the first code file to be read.  
	// FileName - full name including path, file name and extension	
	// This function will reset all code buffer contents before it reads the 
	// selected file (will clear appended files)
	//  return: 0 - FALSE,  1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	INT_X  MSPPRG_API	F_ReadCodeFile_BaseAddr( char * FileName, UINT32 baseAddr );
	// Same as F_ReadCodeFile, but adds baseAddr to all data, useful for reading binary files

	INT_X  MSPPRG_API	F_AppendCodeFile( char * FileName );
	// Append code file contents to existing code buffer.  Up to 20 files in total
	//  return: 1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA		
	INT_X  MSPPRG_API	F_AppendCodeFile_BaseAddr( char * FileName, UINT32 baseAddr );
	// Same as F_AppendCodeFile, but adds baseAddr to all data, useful for reading binary files	
	
	INT_X  MSPPRG_API	F_Get_CodeCS( INT_X dest );
	//  return: 0 - FALSE,  X - checksum of selected buffer, dest:
	//2: code used in last F_AutoProgram or F_Memory_Write operation.
	//0x10: code from internal Code Buffer
	//0x11: Target 1 flash memory read after last F_AutoProgram or F_Memory_Verify operation.
	//0x12: Target 2 flash memory read after last F_AutoProgram or F_Memory_Verify operation.
	//0x13: Target 3 flash memory read after last F_AutoProgram or F_Memory_Verify operation.
	//0x14: Target 4 flash memory read after last F_AutoProgram or F_Memory_Verify operation.
	//0x15: Target 5 flash memory read after last F_AutoProgram or F_Memory_Verify operation.
	//0x16: Target 6 flash memory read after last F_AutoProgram or F_Memory_Verify operation.
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA		

	INT_X  MSPPRG_API	F_Clr_Code_Buffer( void  );
	// Clear Code Buffer (Figure 1.2, GP-ARM-API-DLL-User-Guide.pdf)
	//  return: 0 - FALSE,  1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Put_Byte_to_Code_Buffer( INT_X  addr, BYTE data );
	// Write byte to Code Buffer (Figure 1.2, GP-ARM-API-DLL-User-Guide.pdf)
	//  return: 0 - FALSE,  1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Put_Byte_Block_to_Code_Buffer(uint32_t addr, uint8_t *buffer, uint32_t buffer_size);
	// Write byte block Code Buffer (Figure 1.2, FP-ARM-API-DLL-User-Guide.pdf)
	//  return: 0 - FALSE,  1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Get_Byte_from_Code_Buffer( INT_X  addr );
	// Read byte from Code Buffer (Figure 1.2, GP-ARM-API-DLL-User-Guide.pdf)
	//  return: 0 to 0xFF - byte from buffer,  -1 - addr parameter out of range
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Put_Byte_to_Buffer( INT_X  addr, BYTE data );	
	// Write byte to temporary Write Buffer (Figure 1.2, GP-ARM-API-DLL-User-Guide.pdf)
	//  return: 0 - FALSE,  1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Put_Byte_to_Gang_Buffer( BYTE target_no, INT_X addr, BYTE data );	
	//target_no = 1 to 6. Dedicated buffer for each target.  This function will set one byte of data
	//in Gang Write Buffer assigned to specified Gang target MCU (1 to 6) (Figure 1.2, GP-ARM-API-DLL-User-Guide.pdf)
	//use with F_Copy_Gang_Buffer_to_Flash
	//  return: 0 - FALSE,  1 - TRUE  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Get_Byte_from_Gang_Buffer( BYTE target_no, INT_X addr );	
	//target_no = 1 to 6. Dedicated buffer for each target.  This function will read one byte of data
	//from Gang Read Buffer assigned to specified Gang target MCU (1 to 6) (Figure 1.2, GP-ARM-API-DLL-User-Guide.pdf)
	//use with F_Copy_Flash_to_Gang_Buffer		
	//  return: 0 to 0xFF - byte from buffer,  -1 - addr parameter out of range
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA
	
  	// ------------------------------------------------------------------------

	// ------------------------  Encapsulated Functions -----------------------
	/*
	These functions perform all device actions from beginning to end automatically. These functions require
	that all FPAs were opened using Multi API-DLL function F_OpenInstancesAndFPAs and each API-DLL instance 
	was correctly initialized using Generic Functions.  If not already included in configuration settings, 
	the code being programmed by each FPA to its target device can be set using Data Buffer Functions

	Encapsulated functions use the following sequence:
		- FPA opens target device according to configuration settings,
		- FPA establishes communicatino with target device (JTAG/SWD), check ID, calibrates clock,
		- FPA performs selected encapsulated function,
		- FPA terminates communication with target device,
		- FPA closes target device according to configuration settings (power, start app, adapter line states, etc.)
	*/
	INT_X  MSPPRG_API	F_AutoProgram( INT_X mode = 0 );// mode -> 0 value 1..up  reserved
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Verify_Access_to_MCU( void );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Memory_Erase( INT_X mode = 0 );
	//mode-> 0 -> erase space specify by the FlashEraseModeIndex;
	//mode-> 1 -> erase all Flash memory, regardless FlashEraseModeIndex;
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Memory_Blank_Check( void );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Memory_Write( INT_X mode = 0 );// mode -> 0 value 1..up  reserved	
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Memory_Verify( INT_X mode = 0 );// mode -> 0 value 1..up  reserved	
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Memory_Read( void );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Lock_MCU( void );//F_Write_Locking_Registers + F_Write_Debug_Register
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	INT_X  MSPPRG_API	F_Clear_Locked_Device( void );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6

	// ------------------------------------------------------------------------

	// ---------------------  Sequential Functions ----------------------------
	/*
	Sequential functions allow access to the target device in any
	combination of the small instructions like erase, read, write sector,
	modify part of memory etc. 

	F_OpenInstancesAndFPAs
	F_Set_FPA_index
	F_Initialization
	F_ConfigFileLoad
	F_Open_Target_Device
	... < sequential functions here > ...
	F_Close_Target_Device
	*/
		
	INT_X  MSPPRG_API	F_Open_Target_Device( void );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Close_Target_Device( void );
	//  return: 0 - not executed,  1 - executed  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	
	
	INT_X  MSPPRG_API	F_Segment_Erase( INT_X  address );	
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Sectors_Blank_Check( INT_X  start_addr, INT_X  stop_addr );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Copy_Buffer_to_Flash( INT_X  start_addr, INT_X  size );		
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Copy_Flash_to_Gang_Buffer( INT_X start_addr, INT_X size );  
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Copy_Gang_Buffer_to_Flash( INT_X start_addr, INT_X size );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Write_Byte_to_RAM( INT_X  addr, BYTE data );
	//writes same data to all Gang MCU, any address not in flash
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Write_Word16_to_RAM( INT_X  addr, INT_X data );
	//writes same data to all Gang MCU, any address not in flash
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Write_Word32_to_RAM( INT_X  addr, INT_X data );
	//writes same data to all Gang MCU, any address not in flash
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Write_Bytes_Block_to_RAM( INT_X start_addr, INT_X size, BYTE *data );
	//writes same data to all Gang MCU, any address not in flash	
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA

	INT_X  MSPPRG_API	F_Gang_Read_Byte( BYTE target_no, INT_X addr );
	// read byte from any location of memory, registers etc.
	//  return: 0 to 0xFF  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA		

	INT_X  MSPPRG_API	F_Gang_Read_Word16( BYTE target_no, INT_X addr );
	// read byte from any location of memory, registers etc.
	//  return: 0 to 0xFFFF  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Gang_Read_Word32( BYTE target_no, INT_X addr );
	// read byte from any location of memory, registers etc.
	//  return: 0 to 0xFFFFFFFF  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Gang_Read_Bytes_Block( INT_X addr, INT_X size, BYTE data[][GANG_SIZE] );
	// read byte from any location of memory, registers etc.
	//  return: read results in data buffer
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX
	
	INT_X  MSPPRG_API	F_Set_PC_and_RUN( INT_X  PC_addr );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA

	INT_X  MSPPRG_API	F_Write_Locking_Registers( void );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA

	INT_X  MSPPRG_API	F_Write_Debug_Register( void );
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF)
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA

	#define	GET_MCU_ID			1//MCU package identifier (MCU family and group, etc.), not a unique silicon ID
	#define	GET_MCU_FLASH_SIZE	2
	#define GET_MCU_RAM_SIZE	3
	#define GET_MCU_TARGET_1	0x10
	#define GET_MCU_TARGET_2	0x20
	#define GET_MCU_TARGET_3	0x30
	#define GET_MCU_TARGET_4	0x40
	#define GET_MCU_TARGET_5	0x50
	#define GET_MCU_TARGET_6	0x60	
	INT_X  MSPPRG_API	F_Get_MCU_Data( INT_X Type = (GET_MCU_ID | GET_MCU_TARGET_1) );	
	//Not all MCUs contain Flash size/RAM size in ID register
	//Select one target
	//  return: MCU Data if result is positive ( >= 0) 
	//  return:  0 - FALSE,  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	


	INT_X  MSPPRG_API	F_Capture_PC_Addr( BYTE target_no );
	//read program counter (PC) register using debug interface from selected target device
	//  return: PC if result is positive ( >= 0) 
	//  return:  0 - FALSE,  or Error number
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Synch_CPU_JTAG();
	//stop CPU (debug enable and halt)	
	//  return:  0 - FALSE, TRUE MASK (0x01..0xFF),
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Get_Targets_Result( void );
	//TRUE MASK (0x01..0xFF) - useful to get per-target success result for encapsulated functions
	//0x01  - target 1
	//0x02  - target 2
	//0x04  - target 3
	//0x08  - target 4
	//0x10  - target 5
	//0x20  - target 6
	//Produce error mask using:
	//err_mask = F_Get_Active_Targets_Mask() - F_Get_Targets_Result();
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	INT_X  MSPPRG_API	F_Get_Active_Targets_Mask( void );
	//set intended target mask using: F_Set_Config_Value_By_Name("Target_EN", <target OR> i.e. 0xFF );	
	//Value returned by this function is updated during communication initialization, after any encapsulated function
	//or F_Open_Target_Device
	//0x01  - target 1
	//0x02  - target 2
	//0x04  - target 3
	//0x08  - target 4
	//0x10  - target 5
	//0x20  - target 6
	//0x40  - target 7
	//0x80  - target 8
	//result 0xFF -> all targets
	//  F_Set_FPA_index fpa = 1....MAX_FPA_INDEX  or  0 -> ALL_ACTIVE_FPA	

	// ---------------------  Debugging Functions ----------------------------
	// All debugging functions require specific FPA index; F_Set_FPA_index fpa = 1....MAX_FPA_INDEX
	INT_X   MSPPRG_API  F_Open_Comm(UINT32 activeReset);
	//Open debug communication
	// return: 0 - FALSE (failed), 1 - TRUE
	// activeReset - keep MCU in reset during initialization

	//INT_X  MSPPRG_API	F_Reset_Target( void );hard reset implemented above
	INT_X  MSPPRG_API	F_Soft_Reset_Target(void);
	//Software reset (system reset request AIRCR)
	//  return: 0 - FALSE (no communication), 1 - TRUE, write executed

	INT_X  MSPPRG_API	F_WriteCoreRegister( UINT32 regIndex, UINT32 regValue );
	//Write core register using debug interface
	//  return: 0 - FALSE if invalid register index (unsupported) or no communication, 1 - TRUE if register read, 
	//  regIndex - core register index, 
	//  regValue - value to write to reg. 			
	
	INT_X  MSPPRG_API	F_WriteManyCoreRegisters( UINT32 *regIList, UINT32 *regValue, INT_X size );
	//Write core registers using debug interface
	//	return: 0 - FALSE if invalid register indices or no communication, 1 - TRUE if registers written,
	//  regIList - list of register indices to write, 	
	//  regValue - list of register values to write,
	//  size - list size

	INT_X  MSPPRG_API	F_SetBoot0(INT_X BOOT0_override, INT_X BOOT0_value);
	//Override nTRST pin for BOOT0 control in some MCUs.
	//BOOT0_override == TRUE, force BOOT0_value on nTRST pin
	//BOOT_value, 1/0

	//start UART service functions - XStream and XStreamPro
	INT_X  MSPPRG_API	F_Open_UART( int BR_bps, int Parity_ON, int No_of_Stops );
	//Configure UART connection inside adapter
	//  return: 0 - FALSE (no communication to adapter), 1 - TRUE, parameters set
	// BR_bps - Baud Rate, bits per second, i.e. 9600, 115200, 921600, etc.
	// Parity_ON - parity bit, 1, 0
	// No_of_Stops - number of stop bits

	
	INT_X  MSPPRG_API	F_Close_UART();
	//Close UART connection
	//  return: 0 - FALSE (no communication to adapter), 1 - TRUE, UART turned off inside adapter

	INT_X  MSPPRG_API	F_Gang_TxRx_data_via_UART( int TxSize, int RxSize, int timeout_ms, BYTE * TxData, BYTE ** RxData );
	//  return:  0 - FALSE (timeout on all targets), TRUE MASK (0x01..0xFF), specified number of RxSize bytes received before timeout
	//0x01  - target 1, 0x02  - target 2, 0x04  - target 3, 0x08  - target 4, 0x10  - target 5, 0x20  - target 6
	// TxSize - number of bytes in TxData to be sent
	// RxSize - number of bytes to be received, RxData must contain enough space to write into it
	// timeout_ms - timeout in ms to wait for RxData
	// TxData - buffer with bytes to be sent
	// RxData - buffer that received bytes will be written into (should be preallcoated by caller)
	// RxData should be a dynamically allocated array of RxData[RxSize][GANG_SIZE].  Do not pass a static array, memory corruption will occur.
	//i.e. don't create an array like this RxData[10][GANG_SIZE]  and then pass it with a cast like this (BYTE **)RxData
	//use this code example to malloc RxData:
	//  BYTE **RxData = (BYTE **)malloc((sizeof(BYTE *) * (RxSize)) + ((RxSize) * sizeof(BYTE) * GANG_SIZE)); 
	//  BYTE *const rx_data_off = (BYTE *)(RxData + (RxSize));
	//  for(int i=0; i<RxSize; i++)
	//	  RxData[i] = rx_data_off + i*GANG_SIZE;

	//end UART service functions - XStream and XStreamPro
	INT_X  MSPPRG_API	F_ReadSTM32Certificate(const char *path);
	//return 0 - error or not supported MCU;
	//return 1 - read succes
	//save all certificated in file cert_1.bin, cert_2.bin etc.




#ifndef __GNUC__
#ifdef  MSWIN_API
  MSPPRG_API BOOL   __stdcall 	DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved);
#endif  //MSWIN_API
  MSPPRG_API INT_X	 __stdcall	VB_Trace_File( char *FileName, bool append = false );
  MSPPRG_API void   __stdcall  VB_Trace_Comment(char *comment);
  MSPPRG_API void   __stdcall	VB_Trace_ON( void );
  MSPPRG_API void	 __stdcall	VB_Trace_OFF( void );
  MSPPRG_API INT_X  __stdcall	VB_CloseInstances( void );
  MSPPRG_API INT_X  __stdcall	VB_OpenInstancesAndFPAs( char * FileName );
  MSPPRG_API INT_X  __stdcall	VB_Set_FPA_index( BYTE fpa );
  MSPPRG_API BYTE	 __stdcall	VB_Get_FPA_index( void );
  MSPPRG_API INT_X  __stdcall	VB_Check_FPA_index( void );
  MSPPRG_API INT_X  __stdcall	VB_LastStatus( BYTE fpa );
  MSPPRG_API INT_X  __stdcall	VB_DLLTypeVer( void );
  MSPPRG_API INT_X  __stdcall	VB_Multi_DLLTypeVer( void );
  MSPPRG_API INT_X  __stdcall	VB_Get_FPA_SN( BYTE );
  MSPPRG_API INT_X  __stdcall	VB_Get_FPA_Label( BYTE fpa, BYTE * label );
  MSPPRG_API INT_X  __stdcall	VB_Initialization( void );
  MSPPRG_API INT_X  __stdcall	VB_Get_Device_Info( INT_X index );
  MSPPRG_API INT_X  __stdcall	VB_Reset_Target( void );
  MSPPRG_API INT_X  __stdcall	VB_ReadCodeFile( char * FileName );
  MSPPRG_API INT_X	 __stdcall	VB_AppendCodeFile( char * FileName );
  MSPPRG_API INT_X  __stdcall	VB_ConfigFileLoad( char * Filename );
  MSPPRG_API INT_X  __stdcall  VB_Set_MCU_Name( char * MCU_name );
  MSPPRG_API void   __stdcall  VB_Reset_Config();
  MSPPRG_API BYTE   __stdcall	VB_GetReportMessageChar( INT_X index );
  MSPPRG_API INT_X  __stdcall	VB_Clr_Code_Buffer( void );
  MSPPRG_API INT_X	 __stdcall	VB_Put_Byte_to_Code_Buffer( INT_X addr, BYTE data );
  MSPPRG_API INT_X	__stdcall   VB_Put_Byte_Block_to_Code_Buffer(uint32_t addr, uint8_t *buffer, uint32_t buffer_size);
  MSPPRG_API INT_X	 __stdcall	VB_Get_Byte_from_Code_Buffer( INT_X addr );
  MSPPRG_API INT_X	 __stdcall	VB_Put_Byte_to_Buffer( INT_X addr, BYTE data );  
  MSPPRG_API INT_X	 __stdcall	VB_Put_Byte_to_Gang_Buffer( BYTE n, INT_X addr, BYTE data );
  MSPPRG_API INT_X	 __stdcall	VB_Get_Byte_from_Gang_Buffer( BYTE n, INT_X addr );
  MSPPRG_API INT_X  __stdcall	VB_AutoProgram( INT_X mode );
  MSPPRG_API INT_X  __stdcall	VB_Verify_Access_to_MCU( void );
  MSPPRG_API INT_X  __stdcall	VB_Memory_Erase( INT_X mode );
  MSPPRG_API INT_X  __stdcall	VB_Memory_Blank_Check( void );
  MSPPRG_API INT_X  __stdcall	VB_Memory_Write( INT_X mode );
  MSPPRG_API INT_X  __stdcall	VB_Memory_Verify( INT_X mode );
  MSPPRG_API INT_X	 __stdcall	VB_Memory_Read( void );
  MSPPRG_API INT_X	 __stdcall	VB_Lock_MCU( void );
  MSPPRG_API INT_X	 __stdcall	VB_Clear_Locked_Device( void );
  MSPPRG_API INT_X	 __stdcall	VB_Open_Target_Device( void );
  MSPPRG_API INT_X  __stdcall	VB_Close_Target_Device( void );
  MSPPRG_API INT_X  __stdcall	VB_Segment_Erase( INT_X  address );
  MSPPRG_API INT_X  __stdcall	VB_Sectors_Blank_Check( INT_X  start_addr, INT_X  stop_addr );
  MSPPRG_API INT_X  __stdcall	VB_Copy_Buffer_to_Flash( INT_X  start_addr, INT_X  size );
  MSPPRG_API INT_X	 __stdcall	VB_Write_Locking_Registers( void );
  MSPPRG_API INT_X	 __stdcall	VB_Write_Debug_Register( void );
  MSPPRG_API INT_X  __stdcall  VB_Write_Byte_to_RAM( INT_X  addr, BYTE data );
  MSPPRG_API INT_X  __stdcall  VB_Write_Word16_to_RAM( INT_X  addr, INT_X data );
  MSPPRG_API INT_X  __stdcall  VB_Write_Word32_to_RAM( INT_X  addr, INT_X data );
  MSPPRG_API INT_X	 __stdcall	VB_Gang_Read_Byte( BYTE target_no, INT_X addr );
  MSPPRG_API INT_X	 __stdcall	VB_Gang_Read_Word16( BYTE target_no, INT_X addr );
  MSPPRG_API INT_X	 __stdcall	VB_Gang_Read_Word32( BYTE target_no, INT_X addr );
  MSPPRG_API INT_X	 __stdcall	VB_Set_MCU_Family_Group( INT_X type, INT_X index );
  MSPPRG_API INT_X	 __stdcall	VB_Set_PC_and_RUN( INT_X PC_addr );
  MSPPRG_API INT_X  __stdcall	VB_Get_MCU_Data( INT_X  type );
  MSPPRG_API INT_X  __stdcall	VB_Get_Targets_Vcc( void );
  MSPPRG_API void	 __stdcall	VB_Disable_FPA_index( BYTE fpa );
  MSPPRG_API void	 __stdcall	VB_Enable_FPA_index( BYTE fpa );
  MSPPRG_API INT_X  __stdcall	VB_Power_Target( INT_X OnOff );
  MSPPRG_API INT_X	 __stdcall	VB_Set_fpa_IO( BYTE jtag, BYTE jtag_reset, BYTE EMU0, BYTE EMU1 );
  MSPPRG_API INT_X  __stdcall	VB_Get_CodeCS( INT_X dest );
  MSPPRG_API INT_X  __stdcall	VB_Copy_Gang_Buffer_to_Flash( INT_X start_addr, INT_X size );
  MSPPRG_API INT_X	 __stdcall	VB_Copy_Flash_to_Gang_Buffer( INT_X start_addr, INT_X size );
  MSPPRG_API INT_X	 __stdcall	VB_Get_Targets_Result( void );
  MSPPRG_API INT_X	 __stdcall	VB_Get_Active_Targets_Mask( void );
  MSPPRG_API INT_X	 __stdcall	VB_Get_Sector_Size( INT_X address );
  MSPPRG_API INT_X	 __stdcall	VB_Use_Config_INI( BYTE use );
  MSPPRG_API INT_X  __stdcall  VB_Capture_PC_Addr( BYTE target_no );
  MSPPRG_API INT_X  __stdcall  VB_Synch_CPU_JTAG();
  MSPPRG_API INT_X	 __stdcall	VB_GetProgressBar( BYTE fpa );
  MSPPRG_API INT_X  __stdcall	VB_GetLastOpCode( BYTE fpa );  
  MSPPRG_API INT_X  __stdcall	VB_CancelAction();
  MSPPRG_API INT_X	 __stdcall	VB_Set_fpa_io_state( BYTE jtag, BYTE reset, BYTE VccOn );
  MSPPRG_API INT_X	 __stdcall  VB_Get_Power_Results(double *xs_adc);

  MSPPRG_API INT_X	__stdcall	VB_Get_Power_Results_Start();
  MSPPRG_API INT_X	__stdcall	VB_Get_Power_Results_Stop();
  MSPPRG_API std::vector<TRACE_DATA> * __stdcall VB_Get_Power_Results_History();
  MSPPRG_API INT_X	__stdcall	VB_Get_Last_Power_Results_data(double *xs_adc);
  MSPPRG_API INT_X	__stdcall	VB_XS_Update_HW_State(BYTE mode, INT_X data);
  MSPPRG_API INT_X	__stdcall	VB_XS_Clr_ADC_av_history();
  MSPPRG_API INT_X	__stdcall	VB_XS_Current_zeroing(int state, char *txt);

  MSPPRG_API INT_X  __stdcall	VB_Gang_Read_Bytes_Block(INT_X start_addr, INT_X size, BYTE data[][GANG_SIZE]);
  MSPPRG_API INT_X  __stdcall  VB_Write_Bytes_Block_to_RAM( INT_X start_addr, INT_X size, BYTE *data );
  MSPPRG_API char * __stdcall VB_Get_MCU_Name_list( INT_X type, INT_X index );
  MSPPRG_API char * __stdcall VB_Get_Config_Name_List(INT_X index);
  MSPPRG_API unsigned int __stdcall VB_Get_Config_Value_By_Name(char *name, INT_X type);
  MSPPRG_API INT_X	 __stdcall	VB_Set_Config_Value_By_Name(char *name, unsigned int newValue);
#endif //__GNUC__
}

#endif //GANGPRO_DLL_H
