#include <stdio.h>
#include <string>
#include <iostream>
#include <vector>

#ifdef FLASHPROARM
#include "../FlashProARM-Dll.h"
#endif

#ifdef GANGPROARM
#include "../GangProARM-Dll.h"
#endif

using namespace std;

int main(int argc, char* argv[])
{
  int st;

  string input = "FPAsIPs.ini";
  if(argc < 3)
  {
    cout<< "Usage: <config> <code>" << endl;
    return 1;
  }

  F_Trace_ON();
  int count = F_OpenInstancesAndFPAs((char *)input.c_str());
  cout << "F_OpenInstancesAndFPAs : " << dec << count  << endl;

  cout << "API Version " << hex << (0xFFF & F_DLLTypeVer()) << endl;
  cout << "Multi Version " << hex << (0xFFF & F_Multi_DLLTypeVer()) << endl;

  for(int i=1; i<=count; i++)
  {
    cout << "F_Set_FPA_index("<<i<<") : " << dec << F_Set_FPA_index (i) << endl;
    cout << "F_Initialization : " << dec << F_Initialization() << endl;
    cout << F_Report_Message();
    cout << "F_ConfigFileLoad : " << dec << F_ConfigFileLoad( argv[1] ) << endl;
    cout << "F_ReadCodeFile : " << dec << F_ReadCodeFile( argv[2] ) << endl;
  }
  
  cout << "F_Set_FPA_index("<<0<<") : " << dec << F_Set_FPA_index (0) << endl;
  cout << "F_Clear_Locked_Device : " << dec << F_Clear_Locked_Device() << endl;
  cout << "F_AutoProgram : " << dec << F_AutoProgram() << endl;

  for(int i=1; i<=count; i++)
  {
    cout << "F_Set_FPA_index("<<i<<") : " << dec << F_Set_FPA_index (i) << endl;
    cout << F_Report_Message() <<endl;
  }

  F_Trace_OFF();
  
  return 0;
}
