import os
import sys
import ctypes

#FP-ARM - comment this out and uncomment GP-ARM to use demo for GangPro-ARM
if (sys.platform == "win32"):
    libname = "./FlashProARM-FPAsel.dll"
else:
    libname = "libmultifparm.so"
#GP-ARM - commented out - comment this out and uncomment FP-ARM to use demo for FlashPro-ARM
#if (sys.platform == "win32"):
#    libname = "./GangProARM-FPAsel.dll"
#else:
#    libname = "libmultigparm.so"

init_file = bytes('FPAs-setup.ini', 'utf-8')
if (sys.platform == "win32"):
    config_file_path = bytes('ConfigFiles\\EFR32BG12P433F1024.cfg', 'utf-8')
    code_file_path = bytes('CodeFiles\\SL-512k.txt', 'utf-8')
else:
    config_file_path = bytes('ConfigFiles/EFR32BG12P433F1024.cfg', 'utf-8')
    code_file_path = bytes('CodeFiles/SL-512k.txt', 'utf-8')

#Load library
lib = ctypes.cdll.LoadLibrary(libname)

# Get number of connected adapters
instances = lib.F_OpenInstancesAndFPAs(init_file)
print("Connected adapters: {}".format(instances))

# Init all adapters
result = lib.F_Set_FPA_index(0)
print("F_Set_FPA_index(0): {}".format(result))
result = lib.F_Initialization()
print("F_Initialization: {}".format(result))

# Get adapters serial numbers
serials = []
for instance in range(1, instances+1):
    serials.append(lib.F_Get_FPA_SN(instance))
print(serials)

result = lib.F_ConfigFileLoad(config_file_path)
print("F_ConfigFileLoad: {}".format(result))
result = lib.F_ReadCodeFile(code_file_path)
print("F_ReadCodeFile: {}".format(result))

# Select one adapter
result = lib.F_Set_FPA_index(1)
print("F_Set_FPA_index(1): {}".format(result))

# Verify Access (not required with Auto Program)
result = lib.F_Verify_Access_to_MCU()
print("F_Verify_Access_to_MCU: {}".format(result))

# Auto Program
result = lib.F_AutoProgram(0)
print("F_AutoProgram: {}".format(result))

# Print Auto Program text output (same as GUI)
# max length REPORT_MESSAGE_MAX_SIZE 2000
report_s   = ctypes.create_string_buffer(2000)
lib.F_ReportMessage(report_s)
s = report_s.value.decode()
print(s)
