// ===== Communication Inteface  =======
#define	COMM_TYPE_MASK		0xFFF8
#define	COMM_TYPE_SPEED		0x0003

#define	COMM_NONE			0x0004

#define	COMM_JTAG			0x0010
#define	COMM_cJTAG			0x0008
#define	COMM_SWD			0x0020  //used in ARM software
#define	COMM_ICSP			0x0020	//not used in ARM software
#define	COMM_BSL			0x0040	//not used in FP-M and GP-M
#define	COMM_BDM1			0x0040  //used with FP8/GP8
#define COMM_SBW			0x0080  //not used in FP-M and GP-M
#define	COMM_QSPI			0x0080	//the same as SBW - used in FP-M and GP-M
#define	COMM_SCI			0x0100  //not supported a.t.m.
#define	COMM_UART			0x0200  //not supported a.t.m.
#define	COMM_I2C			0x0400
#define	COMM_SWIM			0x0800  //not supported a.t.m.
#define	COMM_CC_DEBUG		0x0800  // SPI like 2 wire debug port
#define	COMM_SPI			0x1000
#define	COMM_TPI			0x2000  //used with FP82/GP82
#define	COMM_PDI			0x4000  //used with FP82/GP82
#define	COMM_UPDI			0x8000  //used with FP82/GP82
#define	COMM_DAP_2W			0x2000  //used with FP83/GP83
#define	COMM_JTAG_PDI       ( COMM_PDI | COMM_JTAG )  //AVR- ATXMega
#define	COMM_MAX_INDEX		(COMM_UPDI | 7 )

#define	COMM_SLOW			0
#define	COMM_MEDIUM			1
#define	COMM_FAST			2

#define	COMM_cJTAG_SLOW		(COMM_cJTAG | COMM_SLOW)
#define	COMM_cJTAG_MED		(COMM_cJTAG | COMM_MEDIUM)
#define	COMM_cJTAG_FAST		(COMM_cJTAG | COMM_FAST)
#define	COMM_JTAG_SLOW		(COMM_JTAG | COMM_SLOW)
#define	COMM_JTAG_MED		(COMM_JTAG | COMM_MEDIUM)
#define	COMM_JTAG_FAST		(COMM_JTAG | COMM_FAST)
#define	COMM_SWD_SLOW		(COMM_SWD | COMM_SLOW) 
#define	COMM_SWD_MED		(COMM_SWD | COMM_MEDIUM) 
#define	COMM_SWD_FAST		(COMM_SWD | COMM_FAST)
#define	COMM_BSL_SLOW		(COMM_BSL | COMM_SLOW)
#define	COMM_BSL_MED		(COMM_BSL | COMM_MEDIUM)
#define	COMM_BSL_FAST		(COMM_BSL | COMM_FAST)
#define	COMM_QSPI_SLOW		(COMM_QSPI | COMM_SLOW) 
#define	COMM_QSPI_MED		(COMM_QSPI | COMM_MEDIUM) 
#define	COMM_QSPI_FAST		(COMM_QSPI | COMM_FAST)
#define COMM_UART_FAST		(COMM_UART | COMM_FAST)
#define COMM_UART_MED		(COMM_UART | COMM_MEDIUM)
#define COMM_UART_SLOW		(COMM_UART | COMM_SLOW)
#define	COMM_I2C_FAST		(COMM_I2C | COMM_FAST)
#define	COMM_I2C_MED		(COMM_I2C | COMM_MEDIUM)
#define	COMM_I2C_SLOW		(COMM_I2C | COMM_SLOW)
#define	COMM_SWIM_FAST		(COMM_SWIM | COMM_FAST)
#define	COMM_SWIM_SLOW		(COMM_SWIM | COMM_SLOW)
#define	COMM_SPI_SLOW		(COMM_SPI | COMM_SLOW) 
#define	COMM_SPI_MED		(COMM_SPI | COMM_MEDIUM) 
#define	COMM_SPI_FAST		(COMM_SPI | COMM_FAST)
#define	COMM_TPI_FAST		(COMM_TPI | COMM_FAST)
#define	COMM_TPI_MED		(COMM_TPI | COMM_MEDIUM)
#define	COMM_TPI_SLOW		(COMM_TPI | COMM_SLOW)
#define	COMM_PDI_FAST		(COMM_PDI | COMM_FAST)
#define	COMM_PDI_MED		(COMM_PDI | COMM_MEDIUM)
#define	COMM_PDI_SLOW		(COMM_PDI | COMM_SLOW)
#define	COMM_UPDI_FAST		(COMM_UPDI | COMM_FAST)
#define	COMM_UPDI_MED		(COMM_UPDI | COMM_MEDIUM)
#define	COMM_UPDI_SLOW		(COMM_UPDI | COMM_SLOW)
#define	COMM_SBW_SLOW		(COMM_SBW | COMM_SLOW)
#define	COMM_SBW_MED		(COMM_SBW | COMM_MEDIUM)
#define	COMM_SBW_FAST		(COMM_SBW | COMM_FAST)
#define	COMM_ICSP_FAST		(COMM_ICSP | COMM_FAST)
#define	COMM_ICSP_MED		(COMM_ICSP | COMM_MEDIUM)
#define	COMM_ICSP_SLOW		(COMM_ICSP | COMM_SLOW)
#define	COMM_DAP_2W_SLOW	(COMM_DAP_2W | COMM_SLOW)
#define	COMM_DAP_2W_MED		(COMM_DAP_2W | COMM_MEDIUM)
#define	COMM_DAP_2W_FAST	(COMM_DAP_2W | COMM_FAST)
#define	COMM_CC_DEBUG_SLOW	(COMM_CC_DEBUG | COMM_SLOW)
#define	COMM_CC_DEBUG_MED	(COMM_CC_DEBUG | COMM_MEDIUM)
#define	COMM_CC_DEBUG_FAST	(COMM_CC_DEBUG | COMM_FAST)
