#include <stdio.h>
#include <string>
#include <iostream>
#include <vector>

#ifdef FLASHPROARM
#include "../FlashProARM-Dll.h"
#endif

#ifdef GANGPROARM
#include "../GangProARM-Dll.h"
#endif

using namespace std;

int main(int argc, char* argv[])
{
  int st;

  string input = "*# *";
  if(argc < 3)
  {
    cout<< "Usage: <config> <code>" << endl;
    return 1;
  }

  F_Trace_ON();
  cout << "F_OpenInstancesAndFPAs : " << dec <<   F_OpenInstancesAndFPAs((char *)input.c_str()) << endl;
  cout << "F_Get_FPA_SN : " << F_Get_FPA_SN(1) << endl;
  cout << "F_Set_FPA_index : " << dec << F_Set_FPA_index (0) << endl;
  cout << "F_Initialization : " << dec << F_Initialization() << endl;
  cout << "API Version " << hex << (0xFFF & F_DLLTypeVer()) << endl;
  cout << "Multi Version " << hex << (0xFFF & F_Multi_DLLTypeVer()) << endl;
  F_Set_FPA_index(1);
  cout << "F_ConfigFileLoad : " << dec << F_ConfigFileLoad( argv[1] ) << endl;
  cout << "F_ReadCodeFile : " << dec << F_ReadCodeFile( argv[2] ) << endl;
  cout << "F_Clear_Locked_Device : " << dec << F_Clear_Locked_Device() << endl;
  cout << "F_AutoProgram : " << dec << F_AutoProgram() << endl;
  F_Trace_OFF();
  cout << F_Report_Message() << endl;
  cout << "Press any key to continue power measurement in infinite loop" << endl;
  char c = getchar();
	
  F_XS_Clr_ADC_av_history();  
  XS_ADC xs_adc;
  while(1)
  {
    F_Get_Power_Results(xs_adc.members);
    cout << "ExtVcc= " << xs_adc.data.ExtVcc;
    cout << " Vcc= " << xs_adc.data.Vcc;
    cout << " Vpp= " << xs_adc.data.Vpp;
    cout << " ExtVccMin= " << xs_adc.data.ExtVccMin;
    cout << " ExtVccMax= " << xs_adc.data.ExtVccMax;
    cout << " VccMin= " << xs_adc.data.VccMin;
    cout << " VccMax= " << xs_adc.data.VccMax;
    cout << " Icc_mA= " << xs_adc.data.Icc_mA;
    cout << " Icc_mA_av4= " << xs_adc.data.Icc_mA_av4;
    cout << " Icc_mA_av16= " << xs_adc.data.Icc_mA_av16;
    cout << " Icc_mA_min= " << xs_adc.data.Icc_mA_min;
    cout << " Icc_mA_max= " << xs_adc.data.Icc_mA_max;
    cout << " Temperature= " << xs_adc.data.Temperature;
    cout << " Icc_mA_av64= " << xs_adc.data.Icc_mA_av64;
    cout << " Icc_mA_av= " << xs_adc.data.Icc_mA_av;
    cout << endl;
    cout.flush();
  }
  return 0;
}
